% We only used this channel for simulation purposes! It is not necessary
% anymore, since we can use the real channel between to smart-phones

lag_vector = [100 150 200 250];

if check_add_channel == 1

data_power_pb = mean(abs(tx_up_channel.^2));
noise_power_pb = data_power_pb/10^(SNR/10);
noise_pb = normrnd(0,sqrt(noise_power_pb/2),[1, length(tx_up_channel')/k]) ...
    + normrnd(0,sqrt(noise_power_pb/2),[1, length(tx_up_channel')/k] )*1i;

% Upsampling and pulse shaping
% Have a look at the transmitter for more information
noise_pb = upfirdn(noise_pb, pulse, k, 1);

% cos and sin for trainng sequence
t_noise = Ts:Ts:Ts*length(noise_pb);
cos_training = sqrt(2)*cos(2*pi*f0*t_noise);
sin_training = -sqrt(2)*sin(2*pi*f0*t_noise);

noise_up_sc = cos_training .* real(noise_pb);
noise_up_ss = sin_training .* imag(noise_pb);

% This is exactly what we expect to receiver at some time in the received
% signal
noise_up = noise_up_sc + noise_up_ss;

rx_passband = tx_up_channel+noise_up;

% Add lag to input

lag_value = get(handles.edit_Lag,'value');
lag = zeros(1,lag_vector(lag_value));

rx_passband = [lag,rx_passband].';

else
    
lag = zeros(1,100);
rx_passband = [lag,tx_up_channel].';

end